
<?php
include '../connection.php';

session_start(); // Ensure session is started

if (!isset($_SESSION['userid'])) {
    if (isset($_COOKIE['userid'])) {
        $_SESSION['userid'] = $_COOKIE['userid'];
    } else {
        header("Location: ../login.php");
        exit();
    }
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $userid = $_SESSION['userid']; // Sender ID
    $BankName = $_POST['BankName'];
    $TransId = $_POST['TransId'];
    $amount = $_POST['amount'];
    $note = $_FILES['note']; // Change to handle file uploads
    $pin = $_POST['pin'];
    $status = "Pending";
    $date = date('Y-m-d');

    // Check the PIN from the student table
    $sqlCheckPin = "SELECT pin FROM student WHERE userid = ?";
    $stmtCheckPin = $con->prepare($sqlCheckPin);
    $stmtCheckPin->bind_param("i", $userid);
    $stmtCheckPin->execute();
    $stmtCheckPin->bind_result($storedPin);
    $stmtCheckPin->fetch();
    $stmtCheckPin->close();

    if ($storedPin === $pin) {
        // Handle file upload
        $uploadDir = '../uploads/'; // Directory to save uploaded files
        $uploadFile = $uploadDir . basename($note['name']);
        $fileType = strtolower(pathinfo($uploadFile, PATHINFO_EXTENSION));

        // Check file type
        $allowedTypes = ['jpg', 'jpeg', 'png', 'gif', 'pdf', 'doc', 'docx'];
        if (in_array($fileType, $allowedTypes) && move_uploaded_file($note['tmp_name'], $uploadFile)) {
            // Prepare the SQL statement to insert into the manual_add_money table
            $sqlInsertTopup = "INSERT INTO manual_add_money (userid, bank_name, trans_id, taka, docs, date, status)
                               VALUES (?, ?, ?, ?, ?, ?, ?)";
            $stmtInsertTopup = $con->prepare($sqlInsertTopup);
            $stmtInsertTopup->bind_param("issssss", $userid, $BankName, $TransId, $amount, $uploadFile, $date, $status);
            if ($stmtInsertTopup->execute()) {
                $_SESSION['message'] = "রিকোয়েস্ট সফল হয়েছে"; // Request successful
            } else {
                $_SESSION['message'] = " দু:খিত! পুনরায় চেষ্টা করুন "; // Error during insertion
            }
            $stmtInsertTopup->close();
        } else {
            $_SESSION['message'] = "দুঃখিত! বৈধ ফাইল আপলোড করুন।"; // Sorry! Upload a valid file.
        }
    } else {
        $_SESSION['message'] = "আপনার পিন নম্বর সঠিক নয়"; // Your PIN number is incorrect
    }

    // Close connection
    $con->close();

    // Redirect back to the appropriate page
    header("Location: index.php");
    exit();
}
?>

<?php include 'header-link.php'; ?>

<main>

	<?php include 'top-bar.php' ?>
    <section>
        <div class="container mt-2 pb-5">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card custom-card">
                        <div class="card-body">
						
							<div class="text-center">
								<i class="profile-icon fa-sharp-duotone fa-solid fa-forklift"></i>
							</div>
							
                            <h6 class="card-title text-center my-3">  এ্যাড মানি ম্যানুয়াল   </h6>

                            <div class="my-3">
                                <form class="form" action="" method="POST" enctype="multipart/form-data">
                                    <div class="mb-3">
                                        <label for="inputField" class="form-label">ব্যাংক সিলেক্ট করুন</label>
                                        <select name="BankName" class="form-select form-control" required>
                                            <?php 
                                                $sql = "SELECT bank_name FROM bank_info";
                                                $result = $con->query($sql);
                                                while ($row = $result->fetch_array()) {
                                                    echo "<option value='" . $row[0] . "'>" . $row[0] . "</option>";
                                                } 
                                            ?>
                                        </select>
                                    </div>

                                    <div class="mb-1">
                                        <label for="inputField" class="form-label">ট্রান্জেকশন আইডি</label>
                                        <input type="text" class="form-control" name="TransId" id="inputField" placeholder="ট্রান্জেকশন আইডি..." required>
                                    </div>

                                    <div class="mb-1">
                                        <label for="inputField" class="form-label">টাকার পরিমাণ</label>
                                        <input type="number" class="form-control" name="amount" id="inputField" placeholder="টাকার পরিমাণ..." required>
                                    </div>

                                    <div class="mb-3">
                                        <label for="note" class="form-label">প্রুফ / ডকুমেন্ট</label>
                                        <input type="file" class="form-control" name="note" id="note" required>
                                    </div>

                                    <div class="mb-3">
                                        <label for="pinField" class="form-label">পিন</label>
                                        <input type="text" class="form-control" name="pin" id="pinField" placeholder="পিন..." required>
                                    </div>

                                    <div class="d-grid">
                                        <button type="submit" class="btn custom-button w-50 mx-auto mb-3">কনফার্ম করুন</button>
                                    </div>
                                </form>    
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>
</body>
</html>
